<?php  global $obox_themename, $input_prefix;

/*****************/
/* Theme Details */

$obox_themename = "Retail Therapy";
$obox_themeid = "retail-therapy";
$obox_productid = "1790";
$obox_presstrendsid = "80ht4mslzq76rya385f9mfdk3iz8g75lg";

/**********************/
/* Include OCMX files */
$include_folders = array("/ocmx/includes/", "/ocmx/theme-setup/", "/ocmx/widgets/", "/ocmx/front-end/", "/ajax/", "/ocmx/interface/");
include_once (get_template_directory()."/ocmx/folder-class.php");
include_once (get_template_directory()."/ocmx/load-includes.php");

/***********************/


add_filter( 'wp_image_editors', 'change_graphic_lib' );

function change_graphic_lib($array) {
  return array( 'WP_Image_Editor_GD', 'WP_Image_Editor_Imagick' );
}



/* Add OCMX Menu Items */

add_action('admin_menu', 'ocmx_add_admin');
function ocmx_add_admin() {
	global $wpdb;

	add_object_page("Theme Options", "Theme Options", 'edit_themes', basename(__FILE__), '', get_template_directory_uri(). '/ocmx/images/ocmx.png');
	add_submenu_page(basename(__FILE__), "General Options", "General", "edit_theme_options", basename(__FILE__), 'ocmx_general_options');
	add_submenu_page(basename(__FILE__), "Adverts", "Adverts", "administrator",  "ocmx-adverts", 'ocmx_advert_options');
	add_submenu_page(basename(__FILE__), "Typography", "Typography", "edit_theme_options", "ocmx-fonts", 'ocmx_font_options');
	add_submenu_page(basename(__FILE__), "Customize", "Customize", "edit_theme_options", "customize.php");
	add_submenu_page(basename(__FILE__), "Help", "Help", "edit_theme_options", "obox-help", 'ocmx_welcome_page');
};
/******************************************************************************/
/* Each theme has their own "No Posts" styling, so it's kept in functions.php */

function ocmx_no_posts(){ ?>
	<li class="post">
		<h2 class="post-title"><?php _e("No Posts Found", 'ocmx'); ?></h2>
		<div class="copy clearfix">
			<?php _e("There are no posts which match your search criterea.", "ocmx"); ?>
		</div>
	</li>
<?php


}

