<?php
/**
 * Class: WCRP_Model_Settings
 *
 * @author Flipper Code <hello@flippercode.com>
 * @version 1.0.0
 * @package woocommerce-reminder-pro
 */

if ( ! class_exists( 'WCRP_Model_Settings' ) ) {

	/**
	 * Setting model for Plugin Options.
	 *
	 * @package woocommerce-reminder-pro
	 * @author Flipper Code <hello@flippercode.com>
	 */
	class WCRP_Model_Settings extends FlipperCode_Model_Base {

		/** Validations on send updates.
			   *
			   * @var array
			   */
		  public $validations = array();
		/**
		 * Intialize Backup object.
		 */
		function __construct() {
			

		}

			/**
			 * Admin menu for Settings Operation
			 *
			 * @return array Admin menu navigation(s).
			 */
		function navigation() {
			return array(
			'wcrp_settings_settings' => __( 'Plugin Settings', WCRP_TEXT_DOMAIN ),
			'wcrp_manage_settings' => __( 'How It Works', WCRP_TEXT_DOMAIN ),
			);
		}

			/**
			 * Install table associated with Rule entity.
			 *
			 * @return string SQL query to install post_widget_rules table.
			 */
		public function install() {

		}

		   /**
			* Get Rule(s)
			*
			* @param  array $where  Conditional statement.
			* @return array         Array of Rule object(s).
			*/
		public function fetch( $where = array() ) {

			$objects = $this->get( $this->table, $where );
			if ( isset( $objects ) ) {
				return $objects;
			}
		}

		/**
		 * Add or Edit Operation.
		 */
		function save() {

			$entityID = '';

			if ( isset( $_REQUEST['_wpnonce'] ) ) {
				$nonce = sanitize_text_field( wp_unslash( $_REQUEST['_wpnonce'] ) ); }

			if ( isset( $nonce ) and ! wp_verify_nonce( $nonce, 'wpgmp-nonce' ) ) {

				die( 'Cheating...' );

			}

			$this->verify( $_POST );
			if ( is_array( $this->errors ) and ! empty( $this->errors ) ) {
				$this->throw_errors();
			}
			if ( isset( $_POST['entityID'] ) ) {
				$entityID = intval( wp_unslash( $_POST['entityID'] ) );
			}

			if ( $entityID > 0 ) {
				$where[ $this->unique ] = $entityID;
			} else {
				$where = '';
			}

			//Update by default plugin settings
			update_option( 'woocommerce-reminder-pro', serialize( wp_unslash( $_POST ) ) );

			$response['success'] = __( 'Setting(s) saved successfully.', AGP_TEXT_DOMAIN );

			return $response;
		}

	}
}
