<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'WCRP_Review_Pending_Reminder' ) ) :

	/**
	 * WCRP_Review_Pending_Reminder class file.
	 *
	 * @author Flipper Code <hello@flippercode.com>
	 * @package woocommerce-reminder-pro
	 */
	class WCRP_Review_Pending_Reminder extends WC_Email
	{
		
		private $getwooSetting;
		private $dboptions;
		private $email_placeholder;
		private $sms_placeholder;
		
		function __construct()
		{
			$this->id               = 'review_pending_reminder';
			$this->customer_email   = true;
			$this->getwooSetting    =get_option('woocommerce_review_pending_reminder_settings');
			$this->dboptions        = unserialize(get_option( 'woocommerce-reminder-pro' ));		
			$this->title            = __( 'Product Review Reminder', WCRP_TEXT_DOMAIN );
			$this->description      = __( 'Customers "Product Review Reminder" sent to customers for submit review or purchased product', WCRP_TEXT_DOMAIN );
			$this->heading          = __( 'Provide Your Valuable Feedbacks', WCRP_TEXT_DOMAIN );
			$this->subject          = __( 'Review Pending Reminder ', WCRP_TEXT_DOMAIN );
			$this->mail_body		= isset($this->getwooSetting['mail_body']) ? $this->getwooSetting['mail_body']:__("Hello {billing_first_name}<br><br>
					Thank you for purchasing {products_name} on {site_name}. We'd love if you help us or other customers by reviewing the product you recently purchased.<br><br>
					It'd take hardly 5 minutes and it would help other customers to know your experience with the product.{email_review_links}<br>Thank You.<br>{site_name}",WCRP_TEXT_DOMAIN);
			$this->sms_content		= isset($this->getwooSetting['sms_content'])?$this->getwooSetting['sms_content']:__("Dear {billing_first_name},Please leave a feedback for Order : {order_no} Thank you -{site_name}",WCRP_TEXT_DOMAIN);
			$this->email_placeholder = __('Enter / Customize the main email content you want to send in delivery reminder email to user. You can use the following placeholder in above text box.',WCRP_TEXT_DOMAIN);
			$this->sms_placeholder   = __('Enter / Customize the main sms content you want to send in delivery reminder sms to user. You can use the following placeholder in above text box. Please enter sms body with minimum amount of 160 characters. For more information please check < a href="https://support.twilio.com/hc/en-us/articles/223181508-Does-Twilio-support-concatenated-SMS-messages-or-messages-over-160-characters-" target="_blank"> here</a>.',WCRP_TEXT_DOMAIN);
			$this->sms_placeholder   .=__('<table class="fc-placeholders-listing"><thead><tr><th>Placeholder Name</th><th>Placeholder Value</th></tr></thead><tbody><tr><td>{order_no}</td><td>Order No.</td></tr><tr><td>{billing_first_name}</td><td>Customer First Name</td></tr><tr><td>{billing_last_name}</td><td>Customer Last Name</td></tr><tr>
			<td>{products_name}</td><td> Products of Order like-<b> Happy Ninja, Woo Album,</b> etc.</td></tr><tr><td>{site_name}</td><td>Your Website Title</td></tr><tr><td>{site_url}</td><td>Your Website URL</td></tr><tr><td>{email_review_links}</td><td>Products Review Link in Email</td></tr><tr><td>{sms_review_link}</td><td>Products Review Link in SMS</td></tr></tbody></table>', WCRP_TEXT_DOMAIN);

			$this->reminder_days    = isset($this->getwooSetting['reminderdays'])?$this->getwooSetting['reminderdays']:0;
			
			// Call parent constructor
				
			parent::__construct();
			
		}
		public function trigger( $order_id ) {

			if ( $order_id ) {
				$this->object = wc_get_order( $order_id );
				$this->find['order-date']      = '{order_date}';
				$this->find['order-number']    = '{order_number}';
				$this->replace['order-date']   = date_i18n( wc_date_format(), strtotime( $this->object->get_date_created() ) );
				$this->replace['order-number'] = $this->object->get_order_number();
			}
			$this->recipient = $this->object->get_billing_email();	
			if ( ! $this->is_enabled() || ! $this->get_recipient() ) {
				return;
			}
			$success = $this->send( $this->get_recipient(), $this->get_subject(), $this->get_content(), $this->get_headers(), $this->get_attachments() );
			unset($this->object);
			return $success;
		}
	
		public function trigger_sms($order_id){

			$this->dboptions = $this->dboptions;
			$AccountSid      = isset($this->dboptions['wcrp_twilio_accountsid'])?$this->dboptions['wcrp_twilio_accountsid']:'';
			$AuthToken = isset($this->dboptions['wcrp_twilio_authtoken'])?$this->dboptions['wcrp_twilio_authtoken']:'';
			$From  = isset($this->dboptions['wcrp_twilio_from_number']) ? $this->dboptions['wcrp_twilio_from_number'] : '';	
			$order = wc_get_order( $order_id );
			$billingphone = $order->get_billing_phone();
			$sms  = $backupsms = $this->sms_content;
			$sms  = $this->collect_placeholder_and_replace($order,$sms);
		    $sms  = strip_tags($sms); 
			$data = array('to'=>$billingphone,'sms'=>$sms);
			$to   = $data['to'];
			$sms  = $data['sms'];
		    $client = new TwilioRestClient($AccountSid, $AuthToken);
		    $data = array(
		    	"From" => $From,
		    	"To" => $to,
		    	"Body" => $sms
		    );
		    $response = $client->request("/2008-08-01/Accounts/$AccountSid/SMS/Messages", "POST", $data);

			if($response->IsError) {

			if($response->ResponseXml->RestException->Code=="21605"){

				$backupsms = $this->replace_fallback_placeholder($order,$backupsms);	
				$backupsms  = strip_tags($backupsms); 
				$data['Body'] = $backupsms;

				$fallback_response = $client->request("/2008-08-01/Accounts/$AccountSid/SMS/Messages", "POST", $data);

				if($fallback_response->IsError) {
					 $status = 'error';
				}
				else {
				 	 $status = 'success';
				}
				}else{
					 $status = 'error';
				}
			}
			else {
			  $status = 'success';
			}
			
		  return $status;
		}

		public function replace_fallback_placeholder($order,$backupsms){

	   		$toReplace = array(
								'sms_review_link'=>'',
								);
			$backupsms = $this->replace_placeholders($backupsms, $toReplace);
			$backupsms = $this->collect_placeholder_and_replace($order, $backupsms);
			return $backupsms;
	   	} 

		public function collect_placeholder_and_replace($order,$content){

			$billingphone = $order->get_billing_phone();
			$order_id = $order->get_id();
			$billing_first_name = $order->get_billing_first_name();
			$billing_last_name  = $order->get_billing_last_name();
			$items = $order->get_items();
			$product_title = '';	
			$product_link_html = '';
			$product_review_link = '';
			$counter=0;
			foreach ($items as $item) { 
				if(empty($product_title))
					$product_title = ucwords($item['name']);
				else
					$product_title .= ', '.ucwords($item['name']);
				$product_link_html .='<strong> ';
				$product_link_html .= ucwords($item['name']);
				
					

				$product_review_link.= get_the_permalink( $item['product_id']);
				$product_review_link.= '#tab-reviews';
				

				if($counter==(count($items)-1)){
					$product_link_html .='</strong>';
					$product_review_link.='';
				}else{
					$product_link_html .='</strong>, ';
					$product_review_link.=' ,';
				}
				$counter++;	

			}
			$products_title = '';	
			$products_link_html = '';
					
			 $filtereditems = array();
			foreach ($items as $item) { 
				if(empty($products_title))
					$products_title = $item['name'];
				else
					$products_title .= ', '.$item['name'];
				$products_link_html .='<h2><a style="font-size: 14px;" href="'.get_the_permalink( $item['product_id']) .'#tab-reviews" target="_blank">';
				$products_link_html .= __('Click Here To Review for',WCRP_TEXT_DOMAIN).' ';
				$products_link_html .= $item['name'];
				$products_link_html .='</a></h2>';

			}
			$toReplace = array('billing_first_name' => '<b>'.ucwords($billing_first_name).'</b>',
								'billing_last_name' => '<b>'.ucwords($billing_last_name).'</b>',
								'order_no'=>'<b>'.$order_id.'</b>',
								'site_name'=>get_bloginfo('name'),
								'site_url'=>get_bloginfo('url'),
								'products_name'=>$product_link_html,
								'sms_review_link'=>$product_review_link,
								'email_review_links'=>$products_link_html,
								);
			$content = $this->replace_placeholders($content, $toReplace);
			return $content;
		}
	
		// Replace Placeholders from mailbody
		function replace_placeholders($template, $data) {

		    $placeholders = array_keys($data);
		    foreach ($placeholders as &$placeholder) {
		        $placeholder = "{{$placeholder}}";
		    }
		    return str_replace($placeholders, array_values($data), $template);
		}
		/**
		 * Get content html.
		 *
		 * @access public
		 * @return string
		 */
		public function get_content_html() {
			
			  $order = $this->object;
			  $order_id = $this->object->get_id();
			  $email_heading = $this->get_heading();
			  $sent_to_admin = false;
			  $plain_text = false;
			  
			  ob_start();
			  wc_get_template( 'emails/email-header.php', array( 'email_heading' => $email_heading ) );
			  $order_details_header = ob_get_contents();
	 		  ob_get_clean();
			  
			  ob_start();
			  wc_get_template( 'emails/email-footer.php' );
			  $footer = ob_get_contents();
	 		  ob_clean();

			  $mail_body = $this->collect_placeholder_and_replace($order,$this->mail_body);
			  $message = $order_details_header. $mail_body.$footer;
			  //$message = apply_filters('wcrp_product_review_mail_markup',$message,$product_link_html,$order_id);
			 return $message;

		}	
	
		public function init_form_fields() {
		$this->form_fields = array(
			'enabled' => array(
				'title'         => __( 'Enable Email', WCRP_TEXT_DOMAIN ),
				'type'          => 'checkbox',
				'label'         => __( 'Enable Review email notification', WCRP_TEXT_DOMAIN ),
				'default'       => 'yes'
			),
			'sms' => array(
				'title'         => __( 'Enable SMS',WCRP_TEXT_DOMAIN ),
				'type'          => 'checkbox',
				'label'         => __( 'Enable  Review SMS notification', WCRP_TEXT_DOMAIN ),
				'default'       => 'No'
			),
			'reminderdays' => array(
				'title'         => __( 'Product Review Reminder Email/Sms After Days', WCRP_TEXT_DOMAIN ),
				'type'          => 'number',
				'description'   => __( 'Set Number of days for send Review Reminder Notification(By Default 7 Days)', WCRP_TEXT_DOMAIN ),
				'default'       => $this->reminder_days,
				'desc_tip'      => true ,
				'class'			=>'wcrpminrange'
			),
			'subject' => array(
				'title'         => __( 'Subject', WCRP_TEXT_DOMAIN ),
				'type'          => 'text',
				'description'   => sprintf( __( 'This controls the email subject line. Leave blank to use the default subject: <code>%s</code>.', WCRP_TEXT_DOMAIN ), $this->subject ),
				'desc_tip'      => true,
				
			),
			'heading' => array(
				'title'         => __( 'Email Heading', WCRP_TEXT_DOMAIN ),
				'type'          => 'text',
				'description'   => sprintf( __( 'This controls the main heading contained within the email notification. Leave blank to use the default heading: <code>%s</code>.', WCRP_TEXT_DOMAIN ), $this->heading ),
				'desc_tip'      => true
			),
			'email_type' => array(
				'title'         => __( 'Email type', WCRP_TEXT_DOMAIN ),
				'type'          => 'select',
				'description'   => __( 'Choose which format of email to send.', WCRP_TEXT_DOMAIN ),
				'default'       => 'html',
				'class'         => 'email_type wc-enhanced-select',
				'options'       => $this->get_email_type_options(),
				'desc_tip'      => true
			),
			'mail_body' => array(
				'title'         => __( 'Mail Content', WCRP_TEXT_DOMAIN ),
				'type'          => 'textarea',
				'description'   => sprintf( __( ' <code>%s</code>', WCRP_TEXT_DOMAIN ), $this->email_placeholder ),
				 'rows'			=>'20',
				'default'       => $this->mail_body,
				'desc_tip'      => false
			),
			'sms_content' => array(
				'title'         => __( 'Sms Content', WCRP_TEXT_DOMAIN ),
				'type'          => 'textarea',
				'description'   => sprintf( __( ' <code>%s</code>', WCRP_TEXT_DOMAIN ), $this->sms_placeholder ),
				 'rows'			=>'20',
				'default'       => $this->sms_content,
				'desc_tip'      => false
			)
		);
	}
	
	}
	
	endif;


