<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'WCRP_Delivery_Reminder' ) ) :

	/**
	 * WCRP_Delivery_Reminder class file.
	 *
	 * @author Flipper Code <hello@flippercode.com>
	 * @package woocommerce-reminder-pro
	 */

	class WCRP_Delivery_Reminder extends WC_Email
	{
		private $getwooSetting;
		private $dboptions;
		private $email_placeholder;
		private $sms_placeholder;
		
		function __construct()
		{
			
		$this->getwooSetting    = get_option('woocommerce_delivery_reminder_settings');
		$this->dboptions        = get_option( 'woocommerce-reminder-pro' );
		$this->id               = 'delivery_reminder';
		$this->reminder_days    =isset($this->getwooSetting['reminderdays'])?$this->getwooSetting['reminderdays']:0;
		$this->customer_email   = true;
		$this->title            = __( 'Order Delivery Reminder', WCRP_TEXT_DOMAIN );
		$this->description      = __( 'Customers "Order Delivery Reminder" emails sent to the customers at same day of delivery date ', WCRP_TEXT_DOMAIN );
		$this->heading          = __( 'Product Delivery Reminder', WCRP_TEXT_DOMAIN );
		$this->subject          = __( 'Delivery Reminder {site_title}', WCRP_TEXT_DOMAIN );
		$this->mail_body		= isset($this->getwooSetting['mail_body'])?$this->getwooSetting['mail_body']:__("This is product delivery reminder email regarding your order #{order_no} @  {site_name}. <br><br>
			You have following products in your order :<br>
			{order_info_table}<br>
			Products will be shipped {delivery_date_difference} on your shipping address.<br><br>
			{delivery_date}<br>
			{customer_details}<br>
			{billing_details}<br>
			<br><br>
			Thank You.<br>
			{site_name}",WCRP_TEXT_DOMAIN);
		$this->sms_content		= isset($this->getwooSetting['sms_content'])?$this->getwooSetting['sms_content']:__("Dear {billing_first_name},Your Order will deliver today : {order_no} Thank you -{site_name}",WCRP_TEXT_DOMAIN);
		$this->email_placeholder = __('Enter / Customize the main email content you want to send in delivery reminder email to user. You can use the following placeholder in above text box.',WCRP_TEXT_DOMAIN);
		$this->sms_placeholder   = __('Enter / Customize the main sms content you want to send in delivery reminder sms to user. You can use the following placeholder in above text box. Please enter sms body with minimum amount of 160 characters. For more information please check < a href="https://support.twilio.com/hc/en-us/articles/223181508-Does-Twilio-support-concatenated-SMS-messages-or-messages-over-160-characters-" target="_blank"> here</a>.',WCRP_TEXT_DOMAIN);
		$this->sms_placeholder   .=__('<table class="fc-placeholders-listing"><thead><tr><th>Placeholder Name</th><th>Placeholder Value</th></tr></thead><tbody><tr><td>{order_no}</td><td>Order No.</td></tr><tr><td>{billing_first_name}</td><td>Customer First Name</td></tr><tr><td>{billing_last_name}</td><td>Customer Last Name</td></tr><tr>
		<td>{products_name}</td><td> Products of Order like-<b> Happy Ninja, Woo Album,</b> etc.</td></tr><tr><td>{site_name}</td><td>Your Website Title</td></tr><tr><td>{site_url}</td><td>Your Website URL</td></tr><tr><td>{delivery_date_difference}</td><td>Gap Days Between Reminder Email/SMS Date & Delivery Date</td></tr><tr><td>{delivery_date}</td><td>Delivery Date</td></tr><tr><td>{order_info_table}</td><td>Oder Details Information</td></tr></tbody></table>', WCRP_TEXT_DOMAIN);


		// Call parent constructor
		parent::__construct();
			
		}
		public function trigger( $order_id ) {
			if ( $order_id ) {
				$this->object                  = wc_get_order( $order_id );
				$this->find['order-date']      = '{order_date}';
				$this->find['order-number']    = '{order_number}';
				
				$this->replace['order-date']   = date_i18n( wc_date_format(), strtotime( $this->object->get_date_created() ) );
				$this->replace['order-number'] = $this->object->get_order_number();
			}
			$items = $this->object->get_items();
				foreach ($items as $item) {
					$itemname=$item['name'];
				}
			$toReplace = array('Product_title' =>$itemname);
			$this->heading   = $this->replace_placeholders($this->heading, $toReplace); 
			$this->subject   = $this->replace_placeholders($this->subject, $toReplace); 
			$this->recipient = $this->object->get_billing_email();	
			if ( ! $this->is_enabled() || ! $this->get_recipient() ) {
				return;
			}
			$success = $this->send( $this->get_recipient(), $this->get_subject(), $this->get_content(), $this->get_headers(), $this->get_attachments() );
			unset($this->object);
			return $success;
	}


	public function trigger_sms($order_id){

			$this->dboptions = maybe_unserialize($this->dboptions);
			$AccountSid = isset($this->dboptions['wcrp_twilio_accountsid'])?$this->dboptions['wcrp_twilio_accountsid']:'';
			$AuthToken  = isset($this->dboptions['wcrp_twilio_authtoken'])?$this->dboptions['wcrp_twilio_authtoken']:'';
			$From  = isset($this->dboptions['wcrp_twilio_from_number']) ? $this->dboptions['wcrp_twilio_from_number'] : '';	
			$order = wc_get_order( $order_id );
			$billingphone = $order->get_billing_phone();
			$sms = $this->sms_content;

			$sms    = $this->collect_placeholder_and_replace($order,$sms);
			$sms  = strip_tags($sms);
			$data   = array('to'=>$billingphone,'sms'=>$sms);
			$to     = $data['to'];
			$sms    = $data['sms'];
		    $client = new TwilioRestClient($AccountSid, $AuthToken);
		    $data   = array(
		    	"From" => $From,
		    	"To" => $to,
		    	"Body" => $sms
		    );
		    $response = $client->request("/2008-08-01/Accounts/$AccountSid/SMS/Messages", "POST", $data);
			if($response->IsError) {
			  $status = 'error';
		    }
			else {
			  $status = 'success';
		    }
		  return $status;
	}

  	 public function collect_placeholder_and_replace($order,$content){

		$billingphone = $order->get_billing_phone();
		$order_id = $order->get_id();
		$billing_first_name = $order->get_billing_first_name();
		$billing_last_name  = $order->get_billing_last_name();
		$items = $order->get_items();
		$product_link_html = '';

		$counter= 0;
		foreach ($items as $item) { 
			$product_link_html .='<strong>';
			$product_link_html .= ucwords($item['name']);
			if($counter==(count($items)-1)){
				$product_link_html .='</strong>';
			}else{
				$product_link_html .='</strong>, ';
			}

			$counter++;
		}

		ob_start();
		wc_get_template( 'emails/email-order-details.php', array( 'order' => $order, 'sent_to_admin' => false, 'plain_text' => false, 'email' => $this ) );
		$order_details = ob_get_contents();
		ob_get_clean();


		ob_start();
		$fields = array();
		if ( $order->get_billing_email() ) {
			$fields['billing_email'] = array(
				'label' => __( 'Email', WCRP_TEXT_DOMAIN ),
				'value' => wptexturize( $order->get_billing_email() )
			);
		}

		if ( $order->get_billing_phone() ) {
			$fields['billing_phone'] = array(
				'label' => __( 'Tel', WCRP_TEXT_DOMAIN ),
				'value' => wptexturize( $order->get_billing_phone() )
			);
		}
		wc_get_template( 'emails/email-customer-details.php', array( 'fields' => $fields ) );
		$customer_details = ob_get_contents();
		ob_get_clean();

		$delivery_date_html = '';
		$delivery_date = get_post_meta( $order_id, 'Delivery_Date',true);
		$delivery_date_html.='<strong>';
		$delivery_date_html.=__('Delivery Date').' : ';
		$delivery_date_html.='</strong>';
		$delivery_date_html.= $delivery_date;


		ob_start();
		wc_get_template( 'emails/email-addresses.php', array( 'order' => $order ) );
		$shipping_address = ob_get_contents();
		ob_get_clean();

		$delivery_date_string = '';
		if($this->reminder_days==0){
			$delivery_date_string.=__('today',WCRP_TEXT_DOMAIN);
		}
		if($this->reminder_days == 1){
			$delivery_date_string.= __('tomorrow',WCRP_TEXT_DOMAIN);

		}
		if($this->reminder_days>1){
			$delivery_date_string.= __('after '.$this->reminder_days.' days later' ,WCRP_TEXT_DOMAIN);
		}

		
		$toReplace = array('billing_first_name' => '<b>'.ucwords($billing_first_name).'</b>',
							'billing_last_name' => '<b>'.ucwords($billing_last_name).'</b>',
							'order_no'=>'<b>'.$order_id.'</b>',
							'site_name'=>get_bloginfo('name'),
							'site_url'=>get_bloginfo('url'),
							'products_name'=>$product_link_html,
							'order_info_table' =>$order_details,
							'customer_details' =>$customer_details,
							'billing_details' =>$shipping_address,
							'delivery_date_difference'=>$delivery_date_string,
							'delivery_date'=>$delivery_date_html,


							);
		$content    = $this->replace_placeholders($content, $toReplace);
		return $content;
	}
	
	// Replace Placeholders from mailbody
		function replace_placeholders($template, $data) {
		    $placeholders = array_keys($data);
		    foreach ($placeholders as &$placeholder) {
		        $placeholder = "{{$placeholder}}";
		    }
		    return str_replace($placeholders, array_values($data), $template);
		}
		
	/**
	 * Get content html.
	 *
	 * @access public
	 * @return string
	 */
	public function get_content_html() {
				
		  $order = $this->object;
		  $order_id = $this->object->get_id();
		  $email		 = $this;
		  $email_heading = $this->get_heading();
		  $sent_to_admin = false;
		  $plain_text    = false;
		  ob_start();
		  wc_get_template( 'emails/email-header.php', array( 'email_heading' => $email_heading ) );
		  $order_details_header = ob_get_contents();
		  ob_get_clean();
		  ob_start();
		  wc_get_template( 'emails/email-footer.php' );
		  $footer = ob_get_contents();
		  ob_clean();
		  $mail_body = $this->collect_placeholder_and_replace($order,$this->mail_body);
	      $message = $order_details_header. $mail_body.$footer;
	      //$message = apply_filters('wcrp_delivery_reminder_mail_markup',$order_details_header,$mail_body,$footer,$order_id);
		  return $message;

	}


	public function init_form_fields() {		

		$this->form_fields = array(
			'enabled' => array(
				'title'         => __( 'Enable Email', WCRP_TEXT_DOMAIN ),
				'type'          => 'checkbox',
				'label'         => __( 'Enable Delivery email notification', WCRP_TEXT_DOMAIN ),
				'default'       => 'yes'
			),
			'sms' => array(
				'title'         => __( 'Enable Sms', WCRP_TEXT_DOMAIN ),
				'type'          => 'checkbox',
				'label'         => __( 'Enable Delivery sms notification', WCRP_TEXT_DOMAIN ),
				'default'       => 'No'
			),
			'reminderdays' => array(
				'title'         => __( 'Gap Days Between Reminder Email/SMS Date & Delivery Date', WCRP_TEXT_DOMAIN ),
				'type'          => 'number',
				'description'   => __( 'Set Number of days for send Order Delivery Reminder Notification(By Default 
					Same Day)', 'woocommerce' ),
				'default'       => $this->reminder_days,
				'class'			=>'wcrpminrange',
				'desc_tip'      => false 
			),
			'subject' => array(
				'title'         => __( 'Subject', WCRP_TEXT_DOMAIN ),
				'type'          => 'text',
				'description'   => sprintf( __( 'This controls the email subject line. Leave blank to use the default subject: <code>%s</code>.', WCRP_TEXT_DOMAIN ), $this->subject ),
				'desc_tip'      => true
			),
			'heading' => array(
				'title'         => __( 'Email Heading', WCRP_TEXT_DOMAIN ),
				'type'          => 'text',
				'description'   => sprintf( __( 'woocommerce_delivery_reminder_settingsThis controls the main heading contained within the email notification. Leave blank to use the default heading: <code>%s</code>.', WCRP_TEXT_DOMAIN ), $this->heading ),
				'desc_tip'      => true
			),
			'email_type' => array(
				'title'         => __( 'Email type', WCRP_TEXT_DOMAIN ),
				'type'          => 'select',
				'description'   => __( 'Choose which format of email to send.', WCRP_TEXT_DOMAIN ),
				'default'       => 'html',
				'class'         => 'email_type wc-enhanced-select',
				'options'       => $this->get_email_type_options(),
				'desc_tip'      => true
			),
			'mail_body' => array(
				'title'         => __( 'Mail Content', WCRP_TEXT_DOMAIN ),
				'type'          => 'textarea',
				'description'   => sprintf( __( '<code>%s</code>', WCRP_TEXT_DOMAIN ), $this->email_placeholder ),
				'rows'			=>'20',
				'default'       => $this->mail_body,
				'desc_tip'      => false
			)
			,
			'sms_content' => array(
				'title'         => __( 'Sms Content', WCRP_TEXT_DOMAIN ),
				'type'          => 'textarea',
				'description'   => sprintf( __( '<code>%s</code>', WCRP_TEXT_DOMAIN ), $this->sms_placeholder ),
				 'rows'			=>'20',
				'default'       => $this->sms_content,
				'desc_tip'      => false
			)
		);
			
	
	}
	
	}
	endif;

