<?php
	defined( 'ABSPATH' ) or die( 'Keep Silent' );
	
	// ==========================================================
	// Flatsome Theme Override
	// ==========================================================
	
	// Flatsome Shortcode Function
	
	function wvs_pro_ux_products( $atts, $content = NULL, $tag ) {
		global $woocommerce;
		$sliderrandomid = rand();
		
		if ( ! is_array( $atts ) ) {
			$atts = array();
		}
		
		extract( shortcode_atts( array(
			                         '_id'                 => 'product-grid-' . rand(),
			                         'title'               => '',
			                         'ids'                 => '',
			                         'style'               => 'default',
			                         'class'               => '',
			
			                         // Ooptions
			                         'back_image'          => TRUE,
			
			                         // Layout
			                         'columns'             => '4',
			                         'columns__sm'         => '',
			                         'columns__md'         => '',
			                         'col_spacing'         => 'small',
			                         'type'                => 'slider', // slider, row, masonery, grid
			                         'width'               => '',
			                         'grid'                => '1',
			                         'grid_height'         => '600px',
			                         'grid_height__md'     => '500px',
			                         'grid_height__sm'     => '400px',
			                         'slider_nav_style'    => 'reveal',
			                         'slider_nav_position' => '',
			                         'slider_nav_color'    => '',
			                         'slider_bullets'      => 'false',
			                         'slider_arrows'       => 'true',
			                         'auto_slide'          => '',
			                         'infinitive'          => 'true',
			                         'depth'               => '',
			                         'depth_hover'         => '',
			                         // posts
			                         'products'            => '8',
			                         'cat'                 => '',
			                         'excerpt'             => 'visible',
			                         'offset'              => '',
			                         'filter'              => '',
			                         // Posts Woo
			                         'orderby'             => '', // normal, sales, rand, date
			                         'order'               => '',
			                         'tags'                => '',
			                         'show'                => '', //featured, onsale
			                         // Box styles
			                         'animate'             => '',
			                         'text_pos'            => 'bottom',
			                         'text_padding'        => '',
			                         'text_bg'             => '',
			                         'text_color'          => '',
			                         'text_hover'          => '',
			                         'text_align'          => 'center',
			                         'text_size'           => '',
			                         'image_size'          => '',
			                         'image_radius'        => '',
			                         'image_width'         => '',
			                         'image_height'        => '',
			                         'image_hover'         => '',
			                         'image_hover_alt'     => '',
			                         'image_overlay'       => '',
		
		                         ), $atts ) );
		
		// if no style is set
		if ( ! $style ) {
			$style = 'default';
		}
		
		$classes_box   = array( 'box' );
		$classes_image = array();
		$classes_text  = array();
		
		// Fix product on small screens
		if ( $style == 'overlay' || $style == 'shade' ) {
			if ( ! $columns__sm ) {
				$columns__sm = 1;
			}
		}
		
		if ( $tag == 'ux_bestseller_products' ) {
			if ( ! $orderby ) {
				$atts[ 'orderby' ] = 'sales';
			}
		} else if ( $tag == 'ux_featured_products' ) {
			$atts[ 'show' ] = 'featured';
		} else if ( $tag == 'ux_sale_products' ) {
			$atts[ 'show' ] = 'onsale';
		} else if ( $tag == 'products_pinterest_style' ) {
			$type            = 'masonry';
			$style           = 'overlay';
			$text_align      = 'center';
			$image_size      = 'medium';
			$text_pos        = 'middle';
			$text_hover      = 'hover-slide';
			$image_hover     = 'overlay-add';
			$class           = 'featured-product';
			$back_image      = FALSE;
			$image_hover_alt = 'image-zoom-long';
		} else if ( $tag == 'product_lookbook' ) {
			$type             = 'slider';
			$style            = 'overlay';
			$col_spacing      = 'collapse';
			$text_align       = 'center';
			$image_size       = 'medium';
			$slider_nav_style = 'circle';
			$text_pos         = 'middle';
			$text_hover       = 'hover-slide';
			$image_hover      = 'overlay-add';
			$image_hover_alt  = 'zoom-long';
			$class            = 'featured-product';
			$back_image       = FALSE;
		}
		
		// Fix grids
		if ( $type == 'grid' ) {
			if ( ! $text_pos ) {
				$text_pos = 'center';
			}
			if ( ! $text_color ) {
				$text_color = 'dark';
			}
			if ( $style !== 'shade' ) {
				$style = 'overlay';
			}
			$columns      = 0;
			$current_grid = 0;
			$grid         = flatsome_get_grid( $grid );
			$grid_total   = count( $grid );
			echo flatsome_get_grid_height( $grid_height, $_id );
		}
		
		// Fix image size
		if ( ! $image_size ) {
			$image_size = 'shop_catalog';
		}
		
		// Add Animations
		if ( $animate ) {
			$animate = 'data-animate="' . $animate . '"';
		}
		
		
		// Set box style
		if ( $class ) {
			$classes_box[] = $class;
		}
		$classes_box[] = 'has-hover';
		if ( $style ) {
			$classes_box[] = 'box-' . $style;
		}
		if ( $style == 'overlay' ) {
			$classes_box[] = 'dark';
		}
		if ( $style == 'shade' ) {
			$classes_box[] = 'dark';
		}
		if ( $style == 'badge' ) {
			$classes_box[] = 'hover-dark';
		}
		if ( $text_pos ) {
			$classes_box[] = 'box-text-' . $text_pos;
		}
		if ( $style == 'overlay' && ! $image_overlay ) {
			$image_overlay = TRUE;
		}
		
		if ( $image_hover ) {
			$classes_image[] = 'image-' . $image_hover;
		}
		if ( $image_hover_alt ) {
			$classes_image[] = 'image-' . $image_hover_alt;
		}
		if ( $image_height ) {
			$classes_image[] = 'image-cover';
		}
		
		// Text classes
		if ( $text_hover ) {
			$classes_text[] = 'show-on-hover hover-' . $text_hover;
		}
		if ( $text_align ) {
			$classes_text[] = 'text-' . $text_align;
		}
		if ( $text_size ) {
			$classes_text[] = 'is-' . $text_size;
		}
		if ( $text_color == 'dark' ) {
			$classes_text[] = 'dark';
		}
		
		$css_args_img = array(
			array( 'attribute' => 'border-radius', 'value' => $image_radius, 'unit' => '%' ),
			array( 'attribute' => 'width', 'value' => $image_width, 'unit' => '%' ),
		);
		
		$css_image_height = array(
			array( 'attribute' => 'padding-top', 'value' => $image_height ),
		);
		
		$css_args = array(
			array( 'attribute' => 'background-color', 'value' => $text_bg ),
			array( 'attribute' => 'padding', 'value' => $text_padding ),
		);
		
		// If default style
		if ( $style == 'default' ) {
			$depth       = get_theme_mod( 'category_shadow' );
			$depth_hover = get_theme_mod( 'category_shadow_hover' );
		}
		
		// Repeater styles
		$repater[ 'id' ]                  = $_id;
		$repater[ 'title' ]               = $title;
		$repater[ 'tag' ]                 = $tag;
		$repater[ 'type' ]                = $type;
		$repater[ 'style' ]               = $style;
		$repater[ 'slider_style' ]        = $slider_nav_style;
		$repater[ 'slider_nav_color' ]    = $slider_nav_color;
		$repater[ 'slider_nav_position' ] = $slider_nav_position;
		$repater[ 'slider_bullets' ]      = $slider_bullets;
		$repater[ 'auto_slide' ]          = $auto_slide;
		$repater[ 'row_spacing' ]         = $col_spacing;
		$repater[ 'row_width' ]           = $width;
		$repater[ 'columns' ]             = $columns;
		$repater[ 'columns__md' ]         = $columns__md;
		$repater[ 'columns__sm' ]         = $columns__sm;
		$repater[ 'filter' ]              = $filter;
		$repater[ 'depth' ]               = $depth;
		$repater[ 'depth_hover' ]         = $depth_hover;
		
		
		ob_start();
		
		echo get_flatsome_repeater_start( $repater );
		
		?>
		<?php
		
		if ( empty( $ids ) ) {
			
			// Get products
			$atts[ 'products' ] = $products;
			$atts[ 'offset' ]   = $offset;
			$atts[ 'cat' ]      = $cat;
			
			$products = ux_list_products( $atts );
			
		} else {
			// Get custom ids
			$ids = explode( ',', $ids );
			$ids = array_map( 'trim', $ids );
			
			$args = array(
				'post__in'            => $ids,
				'post_type'           => 'product',
				'numberposts'         => - 1,
				'posts_per_page'      => - 1,
				'orderby'             => 'post__in',
				'ignore_sticky_posts' => TRUE,
			);
			
			$products = new WP_Query( $args );
		}
		
		if ( $products->have_posts() ) : ?>
			
			<?php while ( $products->have_posts() ) : $products->the_post(); ?>
				
				<?php
				global $product;
				
				if ( $style == 'default' ) {
					wc_get_template_part( 'content', 'product' );
				} else { ?>
					<?php
					
					$classes_col = array( 'col' );
					
					$out_of_stock = get_post_meta( get_the_ID(), '_stock_status', TRUE ) == 'outofstock';
					if ( $out_of_stock ) {
						$classes[] = 'out-of-stock';
					}
					
					if ( $type == 'grid' ) {
						if ( $grid_total > $current_grid ) {
							$current_grid ++;
						}
						$current       = $current_grid - 1;
						$classes_col[] = 'grid-col';
						if ( $grid[ $current ][ 'height' ] ) {
							$classes_col[] = 'grid-col-' . $grid[ $current ][ 'height' ];
						}
						
						if ( $grid[ $current ][ 'span' ] ) {
							$classes_col[] = 'large-' . $grid[ $current ][ 'span' ];
						}
						if ( $grid[ $current ][ 'md' ] ) {
							$classes_col[] = 'medium-' . $grid[ $current ][ 'md' ];
						}
						// Set image size
						if ( $grid[ $current ][ 'size' ] ) {
							$image_size = $grid[ $current ][ 'size' ];
						}
					}
					?>

                    <div class="<?php echo implode( ' ', $classes_col ); ?>" <?php echo $animate; ?>>
                        <div class="<?php echo implode( ' ', apply_filters( 'wvs_pro_ux_products_shortcode_class', array( 'col-inner' ), get_the_ID() ) ); ?>">
							<?php echo woocommerce_show_product_loop_sale_flash(); ?>
                            <div class="product-small <?php echo implode( ' ', $classes_box ); ?>">
                                <div class="box-image" <?php echo get_shortcode_inline_css( $css_args_img ); ?>>
                                    <div class="<?php echo implode( ' ', $classes_image ); ?>" <?php echo get_shortcode_inline_css( $css_image_height ); ?>>
                                        <a href="<?php echo get_the_permalink(); ?>">
											<?php
												if ( $back_image ) {
													echo flatsome_woocommerce_get_alt_product_thumbnail( $image_size );
												}
												echo woocommerce_get_product_thumbnail( $image_size );
											?>
                                        </a>
										<?php if ( $image_overlay ) { ?>
                                        <div class="overlay fill" style="background-color: <?php echo $image_overlay; ?>"></div><?php } ?>
										<?php if ( $style == 'shade' ) { ?>
                                            <div class="shade"></div><?php } ?>
                                    </div>
                                    <div class="image-tools top right show-on-hover">
										<?php do_action( 'flatsome_product_box_tools_top' ); ?>
                                    </div>
									<?php if ( $style !== 'shade' && $style !== 'overlay' ) { ?>
                                        <div class="image-tools <?php echo flatsome_product_box_actions_class(); ?>">
											<?php do_action( 'flatsome_product_box_actions' ); ?>
                                        </div>
									<?php } ?>
									<?php if ( $out_of_stock ) { ?>
                                        <div class="out-of-stock-label"><?php _e( 'Out of stock', 'woocommerce' ); ?></div><?php } ?>
                                </div><!-- box-image -->

                                <div class="box-text <?php echo implode( ' ', $classes_text ); ?>" <?php echo get_shortcode_inline_css( $css_args ); ?>>
									<?php
										do_action( 'woocommerce_before_shop_loop_item_title' );
										
										echo '<div class="title-wrapper">';
										do_action( 'woocommerce_shop_loop_item_title' );
										echo '</div>';
										
										echo '<div class="price-wrapper">';
										do_action( 'woocommerce_after_shop_loop_item_title' );
										echo '</div>';
										
										if ( $style == 'shade' || $style == 'overlay' ) {
											echo '<div class="overlay-tools">';
											do_action( 'flatsome_product_box_actions' );
											echo '</div>';
										}
										
										do_action( 'flatsome_product_box_after' );
									
									?>
                                </div><!-- box-text -->
                            </div><!-- box -->
                        </div><!-- .col-inner -->
                    </div><!-- col -->
				<?php } ?>
			<?php endwhile; // end of the loop. ?>
		
		<?php
		
		endif;
		wp_reset_query();
		
		echo get_flatsome_repeater_end( $repater );
		
		$content = ob_get_contents();
		ob_end_clean();
		
		return $content;
	}
	
	function flatsome_woocommerce_shop_loop_button() {
		
		if ( flatsome_option( 'add_to_cart_icon' ) !== "button" ) {
			return;
		}
		
		global $product;
		
		$args = array();
		
		$defaults = array(
			'quantity'   => 1,
			'class'      => implode( ' ', array_filter( array(
				                                            'product_type_' . $product->get_type(),
				                                            $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
				                                            $product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '',
				                                            esc_attr( 'button' ), // Button
				                                            esc_attr( 'primary' ), // Button color
				                                            'is-' . esc_attr( get_theme_mod( 'add_to_cart_style', 'outline' ) ), // Button style
				                                            'mb-0',
				                                            'is-' . esc_attr( 'small' ), // Button size
			                                            ) ) ),
			'attributes' => array(
				'data-product_id'  => $product->get_id(),
				'data-product_sku' => $product->get_sku(),
				'data-quantity'    => esc_attr( isset( $args[ 'quantity' ] ) ? $args[ 'quantity' ] : 1 ),
				'rel'              => 'nofollow',
			),
		);
		
		$args = apply_filters( 'woocommerce_loop_add_to_cart_args', wp_parse_args( $args, $defaults ), $product );
		
		echo apply_filters( 'woocommerce_loop_add_to_cart_link', sprintf( '<div class="add-to-cart-button"><a href="%s" class="%s" %s>%s</a></div>', esc_url( $product->add_to_cart_url() ), esc_attr( isset( $args[ 'class' ] ) ? $args[ 'class' ] : 'button' ), isset( $args[ 'attributes' ] ) ? wc_implode_html_attributes( $args[ 'attributes' ] ) : '', esc_html( $product->add_to_cart_text() ) ), $product, $args );
		
	}
	
	function flatsome_product_box_actions_add_to_cart() {
		
		// Check if active
		if ( flatsome_option( 'add_to_cart_icon' ) !== "show" ) {
			return;
		}
		
		global $product;
		
		$args = array();
		
		$defaults = array(
			'quantity'   => 1,
			'class'      => implode( ' ', array_filter( array(
				                                            'add-to-cart-grid',
				                                            'product_type_' . $product->get_type(),
				                                            $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
				                                            $product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '',
			                                            ) ) ),
			'attributes' => array(
				'data-product_id'  => $product->get_id(),
				'data-product_sku' => $product->get_sku(),
				'data-quantity'    => esc_attr( isset( $args[ 'quantity' ] ) ? $args[ 'quantity' ] : 1 ),
				'rel'              => 'nofollow',
			),
		);
		
		$args = apply_filters( 'woocommerce_loop_add_to_cart_args', wp_parse_args( $args, $defaults ), $product );
		
		echo apply_filters( 'woocommerce_loop_add_to_cart_link', sprintf( '<a href="%s" class="%s" %s style="width:0"><div class="cart-icon tooltip absolute is-small" title="%s"><strong>+</strong></div></a>', esc_url( $product->add_to_cart_url() ), esc_attr( isset( $args[ 'class' ] ) ? $args[ 'class' ] : 'button' ), isset( $args[ 'attributes' ] ) ? wc_implode_html_attributes( $args[ 'attributes' ] ) : '', esc_html( $product->add_to_cart_text() ) ), $product, $args );
		
	}
	
	add_filter( 'wvs_pro_ux_products_shortcode_class', function ( $classes, $product_id ) {
		
		if ( 'product' === get_post_type( $product_id ) ) {
			$product = wc_get_product( $product_id );
			if ( $product->is_type( 'variable' ) ) {
				$classes[] = 'wvs-pro-product';
				$classes[] = sprintf( 'wvs-pro-%s-cart-button', woo_variation_swatches()->get_option( 'archive_swatches_position' ) );
			}
		}
		
		return $classes;
	}, 10, 2 );
	
	add_action( 'init', function () {
		
		if ( class_exists( 'Flatsome_Default' ) ) {
			
			//remove_filter( 'woocommerce_loop_add_to_cart_link', 'wvs_pro_loop_add_to_cart_link', 20 );
			// add_filter( 'wvs_pro_show_archive_variation_template', '__return_false' );
			//add_action( 'flatsome_product_box_after', 'wvs_pro_archive_variation_template', 110 );
			
			
			if ( get_theme_mod( 'add_to_cart_icon', flatsome_defaults( 'add_to_cart_icon' ) ) === "show" ) {
				add_filter( 'wvs_pro_select_options_text', '__return_empty_string' );
				add_filter( 'wvs_pro_add_to_cart_text', '__return_empty_string' );
			}
			
			remove_shortcode( "ux_bestseller_products" );
			remove_shortcode( "ux_featured_products" );
			remove_shortcode( "ux_sale_products" );
			remove_shortcode( "ux_latest_products" );
			remove_shortcode( "ux_custom_products" );
			remove_shortcode( "product_lookbook" );
			remove_shortcode( "products_pinterest_style" );
			remove_shortcode( "ux_products" );
			
			
			add_shortcode( "ux_bestseller_products", "wvs_pro_ux_products" );
			add_shortcode( "ux_featured_products", "wvs_pro_ux_products" );
			add_shortcode( "ux_sale_products", "wvs_pro_ux_products" );
			add_shortcode( "ux_latest_products", "wvs_pro_ux_products" );
			add_shortcode( "ux_custom_products", "wvs_pro_ux_products" );
			add_shortcode( "product_lookbook", "wvs_pro_ux_products" );
			add_shortcode( "products_pinterest_style", "wvs_pro_ux_products" );
			add_shortcode( "ux_products", "wvs_pro_ux_products" );
			
			
			if ( has_action( 'flatsome_product_box_after' ) ) {
				remove_action( 'woocommerce_after_shop_loop_item', 'wvs_pro_archive_variation_template', 30 );
				remove_action( 'woocommerce_after_shop_loop_item', 'wvs_pro_archive_variation_template', 7 );
			}
			
			$position = ( 'after' === woo_variation_swatches()->get_option( 'archive_swatches_position' ) ? 100 : 90 );
			add_action( 'flatsome_product_box_after', 'wvs_pro_archive_variation_template', $position );
		}
	} );
	
	
	// ==========================================================
	// OceanWP Theme Override
	// ==========================================================
	
	add_action( 'init', function () {
		
		if ( class_exists( 'OCEANWP_Theme_Class' ) ) {
			remove_action( 'woocommerce_after_shop_loop_item', 'wvs_pro_archive_variation_template', 30 );
			remove_action( 'woocommerce_after_shop_loop_item', 'wvs_pro_archive_variation_template', 7 );
			
			$position = trim( woo_variation_swatches()->get_option( 'archive_swatches_position' ) );
			
			add_action( sprintf( 'ocean_%s_archive_product_add_to_cart', $position ), 'wvs_pro_archive_variation_template' );
			
			add_filter( 'wp_get_attachment_image_attributes', function ( $attr ) {
				$attr[ 'class' ] .= ' wp-post-image';
				
				return $attr;
			} );
		}
	} );
	
	// ==========================================================
	// Shopkeeper Theme Override
	// ==========================================================
	
	add_action( 'init', function () {
		if ( defined( 'GETBOWTIED_WOOCOMMERCE_IS_ACTIVE' ) ) {
			remove_action( 'woocommerce_after_shop_loop_item', 'wvs_pro_archive_variation_template', 30 );
			remove_action( 'woocommerce_after_shop_loop_item', 'wvs_pro_archive_variation_template', 7 );
		}
	} );
	