<?php

namespace WPDesk\SaasPlatformClient\Response\Traits;

use WPDesk\SaasPlatformClient\Response\AuthApiResponse;
use WPDesk\SaasPlatformClient\Response\RawResponse;
use WPDesk\SaasPlatformClient\Response\Response;

trait ApiResponseDecorator
{

    /** @var RawResponse */
    private $rawResponse;

    /**
     * RawResponseDecorator constructor.
     * @param Response $rawResponse
     */
    public function __construct(Response $rawResponse)
    {
        $this->rawResponse = $rawResponse;
    }

    /**
     * Returns response http code
     *
     * @return int
     */
    public function getResponseCode()
    {
        return $this->rawResponse->getResponseCode();
    }

    /**
     * Returns response body as array
     *
     * @return array
     */
    public function getResponseBody()
    {
        return $this->rawResponse->getResponseBody();
    }

    /**
     * Returns response body as array
     *
     * @return array
     */
    public function getResponseErrorBody()
    {
        return $this->rawResponse->getResponseErrorBody();
    }

    /**
     * Get links structure to the other request
     *
     * @return array
     */
    public function getLinks()
    {
        $body = $this->getResponseBody();
        return $body['_links'];
    }

    /**
     * Is it a BAD REQUEST response
     *
     * @return bool
     */
    public function isBadRequest()
    {
        return $this->getResponseCode() === RawResponse::RESPONSE_CODE_ERROR_BAD_REQUEST;
    }

    /**
     * Is it a FATAL ERROR response
     *
     * @return bool
     */
    public function isServerFatalError()
    {
        return $this->getResponseCode() === RawResponse::RESPONSE_CODE_ERROR_FATAL;
    }

    /**
     * Is any error occured
     *
     * @return bool
     */
    public function isError()
    {
        return $this->rawResponse->isError();
    }

    /**
     * Is requested resource exists
     *
     * @return bool
     */
    public function isNotExists()
    {
        return $this->getResponseCode() === AuthApiResponse::RESPONSE_CODE_NOT_EXISTS;
    }

    /**
     * Is maintenance.
     *
     * @return bool
     */
    public function isMaintenance()
    {
        return $this->rawResponse->isMaintenance();
    }

}