<?php

namespace WPDesk\SaasPlatformClient\Model\Shipment;

use WPDesk\SaasPlatformClient\Model\AbstractModel;

/**
 *
 * @package App\Dto
 */
final class ShipmentResponse extends AbstractModel
{
    /** @var int */
    protected $shipmentId;

    /** @var string */
    protected $status;

    /** @var string|null */
    public $message;

    /** @var string */
    public $trackingId;

    /** @var string */
    public $trackingUrl;

    /** @var string */
    public $shipmentCountSent;

    /** @var string */
    public $shipmentCountLeft;

    /** @var ClientMoney */
    public $shipmentCost;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->shipmentCost = new ClientMoney();
        parent::__construct($data);
    }

    /**
     * @return int
     */
    public function getShipmentId()
    {
        return $this->shipmentId;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return null|string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @return string
     */
    public function getTrackingId()
    {
        return $this->trackingId;
    }

    /**
     * @return string
     */
    public function getTrackingUrl()
    {
        return $this->trackingUrl;
    }

    /**
     * @return string
     */
    public function getShipmentCountSent()
    {
        return $this->shipmentCountSent;
    }

    /**
     * @return string
     */
    public function getShipmentCountLeft()
    {
        return $this->shipmentCountLeft;
    }

    /**
     * @return ClientMoney
     */
    public function getShipmentCost()
    {
        return $this->shipmentCost;
    }
}