<?php

namespace WPDesk\SaasPlatformClient\HttpClient;


class HttpClientResponse
{
    /** @var  string */
    private $headers;

    /** @var  string */
    private $body;

    /** @var int */
    private $code;

    /**
     * HttpClientResponse constructor.
     * @param string $headers
     * @param string $body
     * @param int $code
     */
    public function __construct($headers, $body, $code)
    {
        $this->headers = $headers;
        $this->body = $body;
        $this->code = $code;
    }

    /**
     * @return array
     */
    public function getHeaders()
    {
        return explode("\r\n", $this->headers);
    }

    /**
     * @return string
     */
    public function getBody()
    {
        return $this->body;
    }

    /**
     * @return int
     */
    public function getResponseCode()
    {
        return $this->code;
    }
}