<?php

namespace WPDesk\SaasPlatformClient\Cache;

interface CacheInfoResolver
{

    /**
     * Is supported.
     *
     * @param object $object
     *
     * @return bool
     */
    public function isSupported($object);

    /**
     * Should be cached.
     *
     * @param object $object
     *
     * @return bool
     */
    public function shouldCache($object);

    /**
     * Prepare how to cache.
     *
     * @param object $object
     *
     * @return HowToCache
     */
    public function prepareHowCache($object);

    /**
     * Should clear cache.
     *
     * @param object $object
     *
     * @return bool
     */
    public function shouldClearCache($object);

    /**
     * Should clear keys.
     *
     * @param object $object
     *
     * @return string[]
     */
    public function shouldClearKeys($object);

}