<?php

namespace WPDesk\SaasPlatformClient\ApiClient;

use WPDesk\SaasPlatformClient\Cache\CacheInfoResolver;
use WPDesk\SaasPlatformClient\Cache\HowToCache;
use WPDesk\SaasPlatformClient\Request\Fields\GetFieldsRequest;
use WPDesk\SaasPlatformClient\Request\Request;
use WPDesk\SaasPlatformClient\Request\ShippingServices\GetListRequest;
use WPDesk\SaasPlatformClient\Request\ShippingServices\GetServiceRequest;
use WPDesk\SaasPlatformClient\Request\ShippingServicesSettings\GetSettingsRequest;
use WPDesk\SaasPlatformClient\Request\ShippingServicesSettings\PutSettingsRequest;
use WPDesk\SaasPlatformClient\Request\Status\GetStatusRequest;

class RequestCacheInfoResolver implements CacheInfoResolver
{

    const DEFAULT_CACHE_TTL    = 86400; //24 hours
    const CACHE_TTL_ONE_MINUTE = 60;

    /**
     * RequestCacheInfoResolver constructor.
     *
     */
    public function __construct()
    {
    }

    /**
     * @param Request $request
     *
     * @return bool
     */
    private function prepareCacheKey($request)
    {
        return md5($request->getEndpoint());
    }

    /**
     *
     * @param Request $request
     *
     * @return bool
     */
    public function isSupported($request)
    {
        if ($request instanceof GetStatusRequest) {
            return true;
        }
        if ($request instanceof GetFieldsRequest) {
            return true;
        }
        if ($request instanceof GetListRequest) {
            return true;
        }
        if ($request instanceof GetServiceRequest) {
            return true;
        }
        if ($request instanceof GetSettingsRequest) {
            return true;
        }
        if ($request instanceof PutSettingsRequest) {
            return true;
        }
        return false;
    }

    /**
     *
     * @param Request $request
     *
     * @return bool
     */
    public function shouldCache($request)
    {
        if ('GET' === $request->getMethod()) {
            return true;
        }
        return false;
    }

    /**
     *
     * @param Request $request
     *
     * @return HowToCache
     */
    public function prepareHowCache($request)
    {
        $howToCache = new HowToCache($this->prepareCacheKey($request), self::DEFAULT_CACHE_TTL);
        if ($request instanceof GetStatusRequest) {
            $howToCache->setCacheTtl(self::CACHE_TTL_ONE_MINUTE);
        }
        return $howToCache;
    }

    /**
     *
     * @param Request $request
     *
     * @return bool
     */
    public function shouldClearCache($request)
    {
        if ($request instanceof PutSettingsRequest) {
            return true;
        }
        return false;
    }

    /**
     *
     * @param Request $request
     *
     * @return string[]
     */
    public function shouldClearKeys($request)
    {
        if ('GET' !== $request->getMethod()) {
            return [$this->prepareCacheKey($request)];
        }
        return [];
    }


}